#!/bin/bash

pwd

# patiets No = ???????
for Patient in ???????

do
# Getting into DT directory
cd ./${Patient}/DT/

pwd
echo "Now, producing xtract transformation matrices"
date

cp i_den_unr_preproc_unbiased_brain.nii.gz ./Tractography.bedpostX/nodif_brain.nii.gz

flirt -in ./Tractography.bedpostX/nodif_brain -ref ../T1/i_brain.nii.gz -omat ./Tractography.bedpostX/xfms/diff2str.mat -searchrx -180 180 -searchry -180 180 -searchrz -180 180 -dof 6 -cost corratio
convert_xfm -omat ./Tractography.bedpostX/xfms/str2diff.mat -inverse ./Tractography.bedpostX/xfms/diff2str.mat
flirt -in ../T1/i_brain.nii.gz -ref ${FSLDIR}/data/standard/MNI152_T1_2mm_brain -omat ./Tractography.bedpostX/xfms/str2standard.mat -searchrx -180 180 -searchry -180 180 -searchrz -180 180 -dof 12 -cost corratio
convert_xfm -omat ./Tractography.bedpostX/xfms/standard2str.mat -inverse ./Tractography.bedpostX/xfms/str2standard.mat
convert_xfm -omat ./Tractography.bedpostX/xfms/diff2standard.mat -concat ./Tractography.bedpostX/xfms/str2standard.mat ./Tractography.bedpostX/xfms/diff2str.mat
convert_xfm -omat ./Tractography.bedpostX/xfms/standard2diff.mat -inverse ./Tractography.bedpostX/xfms/diff2standard.mat
fnirt --in=../T1/i.nii.gz --aff=./Tractography.bedpostX/xfms/str2standard.mat --cout=./Tractography.bedpostX/xfms/str2standard_warp --config=T1_2_MNI152_2mm
invwarp -w ./Tractography.bedpostX/xfms/str2standard_warp -o ./Tractography.bedpostX/xfms/standard2str_warp -r ../T1/i_brain.nii.gz
convertwarp -o ./Tractography.bedpostX/xfms/diff2standard_warp -r ${FSLDIR}/data/standard/MNI152_T1_2mm -m ./Tractography.bedpostX/xfms/diff2str.mat -w ./Tractography.bedpostX/xfms/str2standard_warp
convertwarp -o ./Tractography.bedpostX/xfms/standard2diff_warp -r ./Tractography.bedpostX/nodif_brain_mask -w ./Tractography.bedpostX/xfms/standard2str_warp --postmat=./Tractography.bedpostX/xfms/str2diff.mat

cd ../../
done

echo "finishing producing xtract transformation matrices"
pwd
date
