#!/bin/bash

pwd

# patiets No = ???????
for Patient in ???????

do
# Getting into DT directory
cd ./${Patient}/DT/

pwd
echo "Now, running preprocessing process"
date

# Copy original bvecs and bvals, preprocessing will overwitre bvecs and bvals
cp bvecs bvecs_orig
cp bvals bvals_orig

# Converting nii type into MRtrix3 type
mrconvert i.nii.gz i.mif -fslgrad bvecs bvals -datatype float32

# denoize using MRtrix3
dwidenoise i.mif i_den.mif -noise i_noise.mif

# Adjusting gibbs artifacts using MRtrix3
mrdegibbs i_den.mif i_den_unr.mif -axes 0,1

# Making mean images from 2 volumed of PA b0 images
mrconvert 2vols_b0_PA.nii.gz - -datatype float32 | mrmath - mean mean_b0_PA.mif -axis 3

# Extracting b0 volume from 4D dti_data
# alternatively; dwiextract i_den_unr.mif b0_AP.mif -bzero
fslsplit i.nii.gz
mv vol0000.nii.gz temp.nii.gz
rm vol????.nii.gz
mv temp.nii.gz vol0002.nii.gz
fslsplit 2vols_b0_AP.nii.gz
fslmerge -t 3vols_b0_AP.nii.gz vol????.nii.gz
rm vol????.nii.gz
mrconvert 3vols_b0_AP.nii.gz - -datatype float32 | mrmath - mean mean_b0_AP.mif -axis 3

# Alternatively, making mean images from 2 volumed of AP b0 images
# mrconvert 2vols_b0_AP.nii.gz - -datatype float32 | mrmath - mean mean_b0_AP.mif -axis 3

# Merging mean_b0_AP and mean_b0_PA into one file named b0_pair
mrcat mean_b0_AP.mif mean_b0_PA.mif -axis 3 b0_pair.mif

# taking TotalReadoutTime from i.json
grep TotalReadoutTime i.json | awk '{ print $2 }' | sed 's/,//' > TotalReadoutTime.txt

# getting TotalReadoutTime
temp_00=$(<./TotalReadoutTime.txt)
TotalReadoutTime=`echo "scale=4; $temp_00/1" | bc`

# Performing topup and eddy current correction
dwifslpreproc i_den_unr.mif i_den_unr_preproc.mif -pe_dir AP -rpe_pair -se_epi b0_pair.mif -eddy_options " --slm=linear" -readout_time $TotalReadoutTime

# Performing B1 field correction
dwibiascorrect ants i_den_unr_preproc.mif i_den_unr_preproc_unbiased.mif -bias bias.mif

# Changing file type (mandatory to this pipeline)
mrconvert i_den_unr_preproc_unbiased.mif i_den_unr_preproc_unbiased.nii.gz -export_grad_fsl bvecs bvals -force

# Changing file type (for checking purpose)
mrconvert mean_b0_PA.mif mean_b0_PA.nii.gz
mrconvert mean_b0_AP.mif mean_b0_AP.nii.gz
mrconvert b0_pair.mif b0_pair.nii.gz

# Cleaning up *.mif files
rm *.mif

# Making brain masks
bet i_den_unr_preproc_unbiased.nii.gz i_den_unr_preproc_unbiased_brain.nii.gz -f 0.3 -g 0 -m

# back into woring directory
cd ../../
done

echo "Finishing preprocessing process"
pwd
date

# the preprocessing procedure is based on the following paper
# https://pubmed.ncbi.nlm.nih.gov/34332375/
